﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace GraphicChart.Core
{
    public class PrepareData
    {

        private List<string> s1;                                     // tu je ulozeny list stringov pre selekciu, teda ak sa kliklo na nejekay obdlznik
        private List<string> sort;                                   // tu je ulozeny list stringov pre selekciu ak sa sortovalo "1a" graf 1 ascending
        private Core.ChartVariables cv;                              // vsetky premenne grafu
        private List<List<string>> data;                             // datovy zdroj grafu
        private List<List<string>> dataTemp;                         // datovy pomocny zdroj grafu
        private List<string> dataX = new List<string>();             // data pre Xovu os
        private List<double> dataY = new List<double>();             // data pre Yovu os
        private List<string> dataTempX = new List<string>();                    // pomocny list
        private List<double> dataTempY = new List<double>();                    // pomocny list
        private List<Core.DataItem> tempSort = new List<Core.DataItem>();       // pomocne pole na zoradovanie

        public PrepareData(List<List<string>> data1, List<string> s, Core.ChartVariables cv1, List<string> sort1)
        {
            s1 = s;
            cv = cv1;
            dataTemp = data1;
            sort = sort1;

            
            data = new List<List<string>>();
            foreach (List<string> rowTemp in dataTemp)
            {
                List<string> listTemp = new List<string>();
                data.Add(listTemp);
                foreach (string sTemp in rowTemp)
                {
                    listTemp.Add(sTemp); 
                }
            }

            PrepareAlternative();
            if (Convert.ToInt32(cv.DateTimeSource) >= 0)
            {
                PrepareGranularity();
            }
            PrepareAndSelect();
            SortData();
        }


        /// <summary>
        /// Pripravi data ak sa "1" alebo na "2"
        /// </summary>
        public void PrepareAlternative()
        {
            foreach (string str in cv.AlternativeList)
            {
                int xDataTmp = Convert.ToInt32( str.Substring(0, str.Length - str.IndexOf(':') - 1) );
                int xDataTmpAlt = Convert.ToInt32(str.Substring(str.IndexOf(':') + 1, str.Length - str.IndexOf(':') - 1));

                for (int i = 0; i < data.Count; i++)
                {
                    data[i][xDataTmp] = data[i][xDataTmp] + "\r\n(" + data[i][xDataTmpAlt] + ")";

                }
            }
        }


        /// <summary>
        /// Pripravi data ak sa kliklo na granularitu
        /// </summary>
        public void PrepareGranularity()
        {
            for (int i = 0; i < data.Count; i++)          
            {
                switch (cv.Granularity)
                {
                    case "month":
                        DateTime dt2 = Convert.ToDateTime(data[i][Convert.ToInt32(cv.DateTimeSource)]);
                        data[i][Convert.ToInt32(cv.DateTimeSource)] = dt2.Month.ToString() +"/"+ dt2.Year.ToString();
                        break;
                    case "term":
                        DateTime dt = Convert.ToDateTime(data[i][Convert.ToInt32(cv.DateTimeSource)]);
                        if (dt.Month < 4) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt.Year.ToString() + "\r\n(1. kvart.)"; }
                        if (dt.Month > 3 && dt.Month < 7) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt.Year.ToString() + "\r\n(2. kvart.)"; }
                        if (dt.Month > 6 && dt.Month < 10) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt.Year.ToString() + "\r\n(3. kvart.)"; }
                        if (dt.Month > 9) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt.Year.ToString() + "\r\n(4. kvart.)"; }
                        break;
                    case "half-year":
                        DateTime dt1 = Convert.ToDateTime(data[i][Convert.ToInt32(cv.DateTimeSource)]);
                        if (dt1.Month <= 6) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt1.Year.ToString() + "\r\n(1. polrok)"; }
                        if (dt1.Month > 6) { data[i][Convert.ToInt32(cv.DateTimeSource)] = dt1.Year.ToString() + "\r\n(2. polrok)"; }                        
                        break;
                    case "year":
                        data[i][Convert.ToInt32(cv.DateTimeSource)] = Convert.ToDateTime(data[i][Convert.ToInt32(cv.DateTimeSource)]).Year.ToString();
                        break;
                }
            }
        }


        /// <summary>
        /// Pripravi data do tvoch listov a vyselektuje hodnoty na ktore bolo "kliknute"
        /// </summary>
        public void PrepareAndSelect() 
        {
            foreach (List<string> row in data)
            {
                // skontroluje ci sa nachadza nieco v liste so selektovanymi datami
                bool isInRow = false;
                bool isInChart = false;
                foreach (string s in s1)
                {
                    if (row.Contains(s)) isInRow = true;
                    if (row[Convert.ToInt32(cv.XData)] == s) isInChart = true;
                }

                if (isInRow == false || isInChart == true)
                {
                    // ak uz je polozka v zozname tak sa k jej hodnote pripocita znova
                    if (dataTempX != null && dataTempX.Contains(row[Convert.ToInt32(cv.XData)]))
                    {
                        dataTempY[dataTempX.IndexOf(row[Convert.ToInt32(cv.XData)])] += Convert.ToDouble(row[Convert.ToInt32(cv.YData)]);
                    }
                    else  //ak nie tak sa tam prida
                    {
                        dataTempX.Add(row[Convert.ToInt32(cv.XData)]);
                        dataTempY.Add(Convert.ToDouble(row[Convert.ToInt32(cv.YData)]));
                    }
                }
            }
        }


        /// <summary>
        /// Zosortuje data
        /// </summary>
        public void SortData()
        {
            // Ak je zadane nejake zoradovanie, naplni sa pomocny list...
            if (dataTempX.Count > 1)
            {
                int i = 0;
                foreach (string sTmp in dataTempX)
                {
                    Core.DataItem cdi = new Core.DataItem();
                    cdi.DataX = sTmp; cdi.DataY = dataTempY[i];
                    tempSort.Add(cdi);
                    i += 1;
                }

                // ...a urobi sa sort po Y datach...
                if (cv.IsXDataDateTime == true)
                {
                    try
                    {
                        DateTime dti = Convert.ToDateTime(tempSort[0].DataX);
                        tempSort.Sort(delegate(Core.DataItem p1, Core.DataItem p2) { return Convert.ToDateTime(p1.DataX).CompareTo(Convert.ToDateTime(p2.DataX)); });
                    }
                    catch (Exception err)
                    {
                        tempSort.Sort(delegate(Core.DataItem p1, Core.DataItem p2) { return p1.DataX.CompareTo(p2.DataX); });
                    }
                }
                else
                {
                    tempSort.Sort(delegate(Core.DataItem p1, Core.DataItem p2) { return p1.DataX.CompareTo(p2.DataX); });
                }


                dataTempX = new List<string>();
                dataTempY = new List<double>();
                foreach (Core.DataItem ii in tempSort)
                {
                    dataTempX.Add(ii.DataX); dataTempY.Add(ii.DataY);
                }


                if (sort.Count > 0)
                {
                    // ...a urobi sa sort po Y datach
                    foreach (string sTmp in sort)
                    {
                        if (sTmp[0].ToString() == cv.ID.ToString())
                        {
                            if (sTmp[1].ToString() == "a")
                            {
                                tempSort.Sort(delegate(Core.DataItem p1, Core.DataItem p2) { return p1.DataY.CompareTo(p2.DataY); });
                            }
                            else
                            {
                                tempSort.Sort(delegate(Core.DataItem p1, Core.DataItem p2) { return p2.DataY.CompareTo(p1.DataY); });
                            }
                        }
                    }
                    dataTempX = new List<string>();
                    dataTempY = new List<double>();
                    foreach (Core.DataItem ii in tempSort)
                    {
                        dataTempX.Add(ii.DataX); dataTempY.Add(ii.DataY);
                    }
                }
            }
            // priradenie datovych prememnnych do hlavnych premmenych
            dataX = dataTempX;
            dataY = dataTempY;
        }


        /// <summary>
        /// Vracia data pre Xovu os
        /// </summary>
        public List<string> ReturnDataX() { return dataX; }


        /// <summary>
        /// Vracia data pre Xovu os
        /// </summary>
        public List<double> ReturnDataY() { return dataY; }


    }
}
